/*
	Zadatak: Pustinja
	-----------------------------------------------
	Zadatak se rjeava pretraivanjem u irinu.
	Pri irenju tijekom neposlunog perioda moramo na svakom koraku 
	provjeravati ako bi se slon tu zaustavio moemo li dalje nastaviti.

	Kada stignemo do zadnjeg dana neposlunog perioda uzeti emo kao da je 
	slon tu ekao jer je to najgora situacija, te ako s njom uspijemo stii 
	do kraja onda smo sigurni da e slon bez obzira na mjesto gdje stane 
	ekati uspjeti stii do destinacije.

	Potrebno je jo pametno pamtiti stanje svakog koraka.
	Stanje definiramo kao (x,y,z, t+p, s) gdje su:
		(x,y) - pozicija slona u pustinji
		z - kolicina uzastopnog sunca ili hlada
		t+p - pozicija unutar ciklusa poslusnog i neposlusnog dijela
		s - jesmo li na poziciji sa suncem ili hladom
*/
#include <iostream>
#include <vector>
#include <queue>
#include <algorithm>
#include <string>
using namespace std;

#define pb(x) push_back(x)
#define mp(a,b) make_pair(a,b)
#define x first
#define y second

#define MAXN 51
#define MAXT 21
#define MAXP 21

class Node
{
public:
	bool sun;
	int x, y, z, t, p;
	Node(int xx, int yy, int zz, bool ssun, int tt, int pp) { x = xx; y = yy; z = zz; sun = ssun; t = tt; p = pp; }
};

int dx[] = { -1, 1, 0, 0 };
int dy[] = { 0, 0, -1, 1 };

int H, W;
int T, P, MaxZ;
pair<int, int> S, E;
vector<string> desert;

queue<Node> Q;
int visited[MAXN][MAXN][MAXT][MAXT+MAXP][2] = { 0 };

bool IsValid(Node p)
{
	if (p.x < 0 || p.x >= H) return false;
	if (p.y < 0 || p.y >= W) return false;
	if (desert[p.x][p.y] =='#') return false;

	return true;
}

int Solve()
{
	visited[S.x][S.y][0][0][0] = visited[S.x][S.y][0][0][1] = 1;

	for (Q.push(Node(S.x, S.y, 0, true, 1, 0)); !Q.empty(); Q.pop())
	{
		Node n = Q.front();

		if (n.x == E.x && n.y == E.y) return visited[n.x][n.y][n.z][n.p][n.sun];

		for (int i = 0; i < 4; ++i)
		{
			Node nn = n;
			nn.x = n.x + dx[i];
			nn.y = n.y + dy[i];
			
			if (!IsValid(nn)) continue;

			int time = visited[n.x][n.y][n.z][nn.p][n.sun] + 1;	
			nn.z = (desert[n.x][n.y] == desert[nn.x][nn.y]) ? (n.z + 1) : 1;
			nn.sun = (desert[nn.x][nn.y] == '.') ? true : false;
			nn.p = (time-2) % (T+P);
			nn.t = n.t + 1;

			if (visited[nn.x][nn.y][nn.z][nn.p][nn.sun] || nn.z > MaxZ) continue;
						
			if ((time-1) % (T+P) > T || (time-1) % (T+P) == 0 )
			{

				if (nn.z + P > MaxZ)
					continue;

				if ((time-1) % (T+P) == T+1)
					nn.t += P;

				if ((time-1) % (T+P) == 0) 
					nn.z += P;
			}

			visited[nn.x][nn.y][nn.z][nn.p][nn.sun] = visited[n.x][n.y][n.z][n.p][n.sun] + 1;
			Q.push(nn);
		}
	}

	return -1;
}

void ReadInput()
{
	cin >> H >> W;
	cin >> T >> P >> MaxZ;
	cin >> S.x >> S.y >> E.x >> E.y;


	desert.resize(H);
	for (int i = 0; i < H; ++i)
		cin >> desert[i];
}

int main()
{
	ReadInput();

	int sol = Solve();
	if (sol == -1 )
		cout << sol << endl;
	else
		cout << sol-1 << endl;

	return 0;	
}
